% readSPM32_FFT_01.m
%RHK is a structure with data from SPM32's SM2 file format header
% taken from RHK SPM 32 version 2004 User's Guide
% RHK structure field names correspond to those of SM2 file format

%**************************************************************************
%**************************************************************************
% read file
%**************************************************************************
%**************************************************************************

%fid = fopen('P:\My Documents\STM image processing\17030509.SM2','r');
%filename = 'Z:\Data\06051702.SM2';
%fid = fopen('Z:\Data\06051702.SM2','r');
%fid = fopen(filename,'r');
filename = 'P:\\My Documents\\STM image processing\\06120100'
filenameR = sprintf('%s.SM2', filename)
fid = fopen(filenameR,'r')

%**************************************************************************
% read fileheader
%**************************************************************************

% initialize file positioning variables
file_pointer = 0;
RHK.sub_type = 0; 
RHK.size = 0;

% search for noise power spectrum data
while RHK.sub_type ~= 5 % should be 6=power spectrum, but SPM32 outputs 5 
% increment file_pointer to beginning of page header
% will increment by 0 when RHK.size = 0 
    file_pointer = file_pointer + RHK.size;
    disp(file_pointer);
% move to start of page header
    fseek(fid,file_pointer,'bof');
% read page header data
    RHK.id = fscanf(fid, '%11c', 1 );
    disp(RHK.id);
    RHK.date = fscanf(fid, '%9c', 1 );
    disp(RHK.date);
    RHK.time = fscanf(fid, '%9c', 1 );
    disp(RHK.time);
    RHK.type = fscanf(fid, '%d', 1 );
    disp(RHK.type);
    RHK.data_type = fscanf(fid, '%d', 1 );
    disp(RHK.data_type);
    RHK.sub_type = fscanf(fid, '%d', 1 );
    disp(RHK.sub_type);
    RHK.x_size = fscanf(fid, '%d', 1 );
    disp(RHK.x_size);
    RHK.y_size = fscanf(fid, '%d', 1 );
    disp(RHK.y_size);
    RHK.size = fscanf(fid, '%d', 1 );
    disp(RHK.size);
    RHK.page_type = fscanf(fid, '%d', 1 );
    disp(RHK.page_type);
    %
    u_text = fscanf(fid, '%s', 1 );
    disp(u_text);
    RHK.xscale = fscanf(fid, '%e', 1 );
    disp(RHK.xscale);
    RHK.xoffset = fscanf(fid, '%e', 1 );
    disp(RHK.xoffset);
    RHK.xunits = fscanf(fid, '%9c', 1 );
    disp(RHK.xunits);
    %
    u_text = fscanf(fid, '%s', 1 );
    disp(u_text);
    RHK.yscale = fscanf(fid, '%e', 1 );
    disp(RHK.yscale);
    RHK.yoffset = fscanf(fid, '%e', 1 );
    disp(RHK.yoffset);
    RHK.yunits = fscanf(fid, '%9c', 1 );
    disp(RHK.yunits);
    %
    u_text = fscanf(fid, '%s', 1 );
    disp(u_text);
    RHK.zscale = fscanf(fid, '%e', 1 );
    disp(RHK.zscale);
    RHK.zoffset = fscanf(fid, '%e', 1 );
    disp(RHK.zoffset);
    RHK.zunits = fscanf(fid, '%10s', 1 );
    disp(RHK.zunits);
    %
    u_text = fscanf(fid, '%s', 1 );
    disp(u_text);
    RHK.xyscale = fscanf(fid, '%e', 1 );
    disp(RHK.xyscale);
    RHK.xy = fscanf(fid, '%s', 1 );
    disp(RHK.xy);
    RHK.angle = fscanf(fid, '%e', 1 );
    disp(RHK.angle);
    %
    u_text = fscanf(fid, '%s', 1 );
    disp(u_text);
    RHK.current = fscanf(fid, '%e', 1 );
    disp(RHK.current);
    RHK.bias = fscanf(fid, '%e', 1 );
    disp(RHK.bias);
    %
    u_text = fscanf(fid, '%s', 1 );
    disp(u_text);
    RHK.scan = fscanf(fid, '%d', 1 );
    disp(RHK.scan);
    RHK.period = fscanf(fid, '%e', 1 );
    disp(RHK.period);
    %
    u_text = fscanf(fid, '%s', 1 );
    disp(u_text);
    RHK.file_id = fscanf(fid, '%d', 1 );
    disp(RHK.file_id);
    RHK.data_offset = fscanf(fid, '%d', 1 );
    disp(RHK.data_offset);
    %{
    RHK.label = fscanf(fid, '%20s', 1 );
    disp('RHK.label');
    disp(RHK.label);
    RHK.text = fscanf(fid, '%160s', 1 );
    disp(RHK.text);
    disp('RHK.text');
    %}
% increment file_pointer to end of page header    
    file_pointer = file_pointer + RHK.data_offset;
    disp(file_pointer);
% read data block
    fseek(fid,file_pointer,'bof');
    A = fread(fid,[RHK.x_size,RHK.y_size],'single');
end
status = fclose(fid);

%**************************************************************************
%**************************************************************************
% scale & plot data
%**************************************************************************
%**************************************************************************
x = zeros(RHK.x_size,RHK.y_size);
frequency = 0;
for n = 1:RHK.x_size
    x(n) = frequency;
    frequency = frequency + RHK.xscale;
end
y = RHK.zscale*A(:,1)/1e-15; % scale and convert to fempto amps
plot(x,y,'-','LineWidth',2), grid on
set(gca,'FontSize',18)
xlabel('Hz')
ylabel('fA/ \surd Hz')
title(['FFT of (', filename, ')'])
%axes('FontSize',14);

%**************************************************************************
%**************************************************************************
% write scaled data to ascii file
%**************************************************************************
%**************************************************************************
if RHK.sub_type == 5

    % write to file
    filenameW = sprintf('%s.fft', filename)
    fid = fopen(filenameW,'w')
    for m = 1:RHK.x_size 
        fprintf(fid,'%8.4f ',x(m));
        fprintf(fid,'\t%8.4f ',y(m));
        fprintf(fid,'\n');
    end
    status = fclose(fid)
end % RHK.sub_type == 5
  



%**************************************************************************
%**************************************************************************
% smooth data
%**************************************************************************
%**************************************************************************
%{
x = A(:,1);
windowSize = 15;
%y = filter(ones(1,windowSize)/windowSize,1,x);
halfWindowSize = round(windowSize/2)-1
nBeg = 1+halfWindowSize
nEnd = length(x)-halfWindowSize
%nBeg = windowSize;
%nEnd = length(x)-windowSize+1;
for n = nBeg:nEnd
    y(n)=0.0;
%    disp(n);
    for m = (n-halfWindowSize):(n+halfWindowSize)
%        disp(m);
        y(n)= y(n) + x(m);
    end
    y(n)= y(n)/windowSize;
end
t = nBeg:nEnd;
plot(t,x(nBeg:nEnd),'-.',t,y(nBeg:nEnd),'-'), grid on
%}
    
    